#include <stdio.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

#include <sys/time.h>


typedef struct frag {
	int fr_length;          /* frag length */
	char *fr_data;          /* frag data */
	struct frag *fr_next;   /* next frag */
} frag;

extern frag *ogchain, *ogcur;
extern XDR ogxdr;

static frag *xab_ogchain, *xab_ogcur;
static XDR xab_ogxdr;

/*
*	xab_save
*	voodoo to save the current message buffer so xab can send out 
*	it's own message.  Should never be called a second time without 
*	calling xab_restore inbetween
*/

void
xab_save()
{
	xab_ogchain = ogchain;
	xab_ogcur = ogcur;
	xab_ogxdr = ogxdr;

	ogchain = ogcur = 0;
}

/*
*	xab_restore
*	restores the saved message buffer.  should only be called sometime after
*	xab_save
*/

xab_restore()
{
	/* clear the hidden message */
	initsend();
	/* reset the previous message buffer */
	ogchain = xab_ogchain;
	ogcur = xab_ogcur;
	ogxdr = xab_ogxdr;
}

/*
*	xab_puttime
*	gets the current time and puts it on the message queue
*/

void
xab_puttime()
{
	long time[2];
	struct timeval tv;
	struct timezone tz;

	if(gettimeofday(&tv, &tz)) {
		fprintf(stderr, "gettimeofday() choked, bailing\n");
		exit(-1);
		}

	/* it might be faster to just call putnlong twice... */
	time[0] = tv.tv_sec;
	time[1] = tv.tv_usec;

	putnlong(time,2);
}
